<?php
session_start();
//error_reporting(E_ALL); // or E_STRICT
//ini_set("display_errors", 1);
require '../connect.php';

if(!isset($_SESSION['admin_user']))
{
header('location:/../admin093');
}
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <!-- Meta, title, CSS, favicons, etc. -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>SSV | View Student</title>

    <!-- Bootstrap -->
    <link href="../vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="../vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet">
    <!-- NProgress -->
    <link href="../vendors/nprogress/nprogress.css" rel="stylesheet">
    <!-- iCheck -->
    <link href="../vendors/iCheck/skins/flat/green.css" rel="stylesheet">

    <!-- Custom Theme Style -->
    <link href="../build/css/custom.min.css" rel="stylesheet">
  </head>

  <body class="nav-md">
    <div class="container body">
      <div class="main_container">
        <div class="col-md-3 left_col">
         <?php include 'sidebar.php';?>
        </div>

        <!-- top navigation -->
        <div class="top_nav">
          <?php include 'topbar.php';?>
        </div>
        <!-- /top navigation -->

        <!-- page content -->
        <div class="right_col" role="main">
          <div class="">
            <div class="page-title">
              <div class="title_left">
                <h3>Send SMS to Absentee<small></small></h3>
              </div>

              
            </div>

            <div class="clearfix"></div>

            <div class="row">
			
			

              <div class="col-md-12 col-sm-12 col-xs-12">
                  
                <div id="success" class="alert alert-success alert-dismissible fade in">
                    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                    <strong>Success!</strong> <span id="smsg"></span>
                </div>
                
                <div id="error" class="alert alert-danger alert-dismissible fade in">
                    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                    <strong>Error!</strong> <span id="emsg"></span>
                </div>
                
                <div class="x_panel">
                 
                    <div class="x_content">
                        <div>
                            <form class="form-horizontal form-label-left" novalidate method="POST">
                                <div class="item form-group">
                                    <label class="control-label col-md-3 col-sm-3 col-xs-12">Standard <span class="required">*</span>
                                    </label>
                                    <div class="col-md-6 col-sm-6 col-xs-12">
                                        <select id="std" class="form-control" name="std">
                                            <option value="0">Please Select</option>
                                            <?php
                                                $query="SELECT * FROM std";
                                                $fire=mysqli_query($connect,$query);
                                                if(mysqli_num_rows($fire) > 0)
                                                {
                                                    while($k=mysqli_fetch_array($fire))
                                                    {
                                            ?>								
                                            <option value="<?php echo $k[0]; ?>"><?php echo $k[1]; ?></option>
                                            <?php
                                                    } 
                                                }
                                            ?>	
                                        
                                        </select>
                                    </div>
                                </div>
                               
                                <div class="form-group">
                                    <div class="col-md-6 col-md-offset-3">
                                        <button type="button" id="btnShow" class="btn btn-info">Show</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="ln_solid"></div>
                        <div id="viewTable">
                            <table id="example" class="table table-striped table-bordered dt-responsive nowrap" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th>Select</th>
                                        <th>Student Name</th>
                                        <th>Father Name</th>
                                        <th>Mother Name</th>
                                        <th>Standard</th>
                                        <th>Medium</th>
                                    </tr>
                                </thead>
                                <tbody>
                        
                                </tbody>
                            </table>
                            <br>
                            <button type="button" id="btnSend" class="btn btn-primary">Send</button>
                        </div>
                    </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- /page content -->

        <!-- footer content -->
        <footer>
          <?php include 'footer.php';?>
        </footer>
        <!-- /footer content -->
      </div>
    </div>

    <!-- jQuery -->
    <script src="../vendors/jquery/dist/jquery.min.js"></script>
    <!-- Bootstrap -->
    <script src="../vendors/bootstrap/dist/js/bootstrap.min.js"></script>
    <!-- FastClick -->
    <script src="../vendors/fastclick/lib/fastclick.js"></script>
    <!-- NProgress -->
    <script src="../vendors/nprogress/nprogress.js"></script>
    <!-- iCheck -->
    <script src="../vendors/iCheck/icheck.min.js"></script>
    <!-- Datatables -->
    <script src="../vendors/jszip/dist/jszip.min.js"></script>
    <script src="../vendors/pdfmake/build/pdfmake.min.js"></script>
    <script src="../vendors/pdfmake/build/vfs_fonts.js"></script>

    <!-- Custom Theme Scripts -->
    <script src="../build/js/custom.min.js"></script>

    <!-- Datatables -->
    <script>
      $(document).ready(function() {
        
        $('#viewTable').hide();
        $('#success').hide();
        $('#error').hide();
        
        $('#btnShow').on("click",function()
        {
           
           var std = $('#std').val();
           var med = 1;
           
           if(std == 0)
           {
               alert("please select standard");
           }
           else if(med == 0)
           {
               alert("please select medium");
           }
           else
           {
               $.ajax({
                  url:"get_student_absent.php",
                  type:"POST",
                  data:{ std:std,med:med },
                  success:function(response)
                  {
                      $('#example tbody').empty();
                      $('#example tbody').append(response);
                      $('#viewTable').show();
                  }
               });
           }
        });
        
        $('#btnSend').on("click",function()
        {
            var arr1 = [];
            $("#example tbody").find('input[name="chk[]"]').each(function(){
                if($(this).is(":checked")){
                    arr1.push($(this).val());
                }
            });
            if(arr1.length > 0)
            {
                $.post("send_absent_message.php",
                {
                    sid : arr1
                },
                function(data, status)
                {
                    //console.log(data);
                    var arr2 = [];
                    var arr2 = JSON.parse(data); 
                    if (arr2.isSuccess == true)
                    {
                        $('#smsg').text("Sent Successfully");
                        $('#success').show();
                        $('#error').hide();
                    }
                    else
                    {
                        $('#emsg').text(arr2.message);
                        $('#error').show();
                        $('#success').hide();
                    }
                });
            }
            else
            {
                alert("please select atleast one student to proceed");
            }
            //console.log(arr1);    
        });
      });
    </script>
    <script>
        
    </script>
    <!-- /Datatables -->
  </body>
</html>